IF  NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[PDV_VD_FECHA_MOV_INTEGRACAO_ENVIO_PENDENTE]') AND type in (N'U'))
begin
	CREATE TABLE [dbo].[PDV_VD_FECHA_MOV_INTEGRACAO_ENVIO_PENDENTE](
		[CD_EMP] [int] NOT NULL,
		[CD_FILIAL] [int] NOT NULL,
		[DT_MOV] [datetime] NOT NULL,
		[DT_CAD] [datetime] NULL,
	 CONSTRAINT [PK_PDV_VD_FECHA_MOV_INTEGRACAO_ENVIO_PENDENTE] PRIMARY KEY CLUSTERED 
	(
		[CD_EMP] ASC,
		[CD_FILIAL] ASC,
		[DT_MOV] ASC
	)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
	) ON [PRIMARY]


	ALTER TABLE [dbo].PDV_VD_FECHA_MOV_INTEGRACAO_ENVIO_PENDENTE ADD  CONSTRAINT [DF_PDV_VD_FECHA_MOV_INTEGRACAO_ENVIO_PENDENTE_CD_EMP]  DEFAULT ((0)) FOR [CD_EMP]

	ALTER TABLE [dbo].PDV_VD_FECHA_MOV_INTEGRACAO_ENVIO_PENDENTE ADD  CONSTRAINT [DF_PDV_VD_FECHA_MOV_INTEGRACAO_ENVIO_PENDENTE_CD_FILIAL]  DEFAULT ((0)) FOR [CD_FILIAL]

	ALTER TABLE [dbo].PDV_VD_FECHA_MOV_INTEGRACAO_ENVIO_PENDENTE ADD  CONSTRAINT [DF_PDV_VD_FECHA_MOV_INTEGRACAO_ENVIO_PENDENTE_DT_MOV]  DEFAULT ((GETDATE())) FOR [DT_MOV]

	ALTER TABLE [dbo].PDV_VD_FECHA_MOV_INTEGRACAO_ENVIO_PENDENTE  WITH CHECK ADD  CONSTRAINT [FK_PDV_VD_FECHA_MOV_INTEGRACAO_ENVIO_PENDENTE_PDV_VD_FECHA_MOV] FOREIGN KEY([CD_EMP],[CD_FILIAL],[DT_MOV])
	REFERENCES [dbo].[PDV_VD_FECHA_MOV] ([CD_EMP],[CD_FILIAL], [DT_MOV])
	ON DELETE CASCADE

	ALTER TABLE [dbo].PDV_VD_FECHA_MOV_INTEGRACAO_ENVIO_PENDENTE CHECK CONSTRAINT [FK_PDV_VD_FECHA_MOV_INTEGRACAO_ENVIO_PENDENTE_PDV_VD_FECHA_MOV]
end